# EOSCONNECT - Setup Guide

## Prerequisites Setup

Follow these steps to set up your environment for running the Jupyter notebook.

### Step 1: Download and Install Visual Studio Code

1. Go to [https://code.visualstudio.com/](https://code.visualstudio.com/)
2. Download the installer for Windows
3. Run the installer and follow the installation wizard
4. Accept the license agreement
5. Choose installation location (default is recommended)
6. Select additional tasks:
   - ✓ Add "Open with Code" action to Windows Explorer file context menu
   - ✓ Add "Open with Code" action to Windows Explorer directory context menu
   - ✓ Add to PATH (recommended)
7. Click Install and wait for completion
8. Launch Visual Studio Code

### Step 2: Download and Install Python

1. Go to [https://www.python.org/downloads/](https://www.python.org/downloads/)
2. Download the latest Python 3.x version for Windows
3. Run the installer
4. **Important:** Check "Add Python to PATH" at the bottom of the installer
5. Click "Install Now" (recommended for most users)
6. Wait for installation to complete
7. Verify installation by opening PowerShell and typing: `python --version`

### Step 3: Install UV

UV is a fast Python package installer and resolver.

1. Open PowerShell
2. Run the following command:
   ```powershell
   powershell -ExecutionPolicy ByPass -c "irm https://astral.sh/uv/install.ps1 | iex"
   ```
3. Wait for the installation to complete
4. For more details, see [UV Installation Guide](https://docs.astral.sh/uv/getting-started/installation/)

### Step 4: Install Visual Studio Code Extensions

1. Open Visual Studio Code
2. Click on the Extensions icon in the left sidebar (or press `Ctrl+Shift+X`)
3. Search for "Python" and install:
   - **Python** (Publisher: Microsoft, ID: ms-python.python)
4. Search for "Jupyter" and install:
   - **Jupyter** (Publisher: Microsoft, ID: ms-toolsai.jupyter)
5. Wait for both extensions to install completely

### Step 5: Restart Visual Studio Code

1. Close Visual Studio Code completely
2. Reopen Visual Studio Code
3. This ensures all extensions are properly loaded

### Step 6: Sync Dependencies

1. In Visual Studio Code, open a terminal (Terminal > New Terminal or `` Ctrl+` ``)
2. Make sure you're in the project directory
3. Run the following command:
   ```bash
   uv sync
   ```
4. Wait for all dependencies to be installed

### Step 7: Open the Notebook

1. In Visual Studio Code, open the file explorer (View > Explorer or `Ctrl+Shift+E`)
2. Navigate to and click on `eosconnect.ipynb`
3. The notebook will open in the editor

### Step 8: Select a Kernel

1. Look at the top-right corner of the notebook
2. Click on "Select Kernel" button
3. Choose "Python Environments..."
4. Select the Python environment created by UV (usually in `.venv` folder)
5. Wait for the kernel to start (you'll see "Idle" in the status bar when ready)

---

## How to Use Jupyter Notebooks

Jupyter notebooks consist of **cells** that can contain either code or markdown text.

### Executing Code Cells

1. **Run a single cell:**
   - Click on the cell to select it
   - Press `Shift+Enter` to run the cell and move to the next one
   - Or press `Ctrl+Enter` to run the cell and stay on it
   - Or click the ▶️ (Play) button that appears on the left of the cell when you hover over it

2. **Run all cells:**
   - Click "Run All" at the top of the notebook
   - Or use the menu: Run > Run All Cells

3. **Run cells above/below:**
   - Use the menu: Run > Run All Cells Above or Run All Cells Below

### Cell Execution Order

- Cells can be run in any order, but for best results, run them sequentially from top to bottom
- The number in brackets `[1]` shows the execution order
- If you see `[*]`, the cell is currently running

### Tips

- **Add new cells:** Click the `+ Code` or `+ Markdown` buttons between cells
- **Clear outputs:** Right-click on output and select "Clear Cell Output"
- **Restart kernel:** If something goes wrong, click "Restart" in the top toolbar to restart the Python kernel
- **Save regularly:** The notebook auto-saves, but you can manually save with `Ctrl+S`